<?php
/* --------------------------------------------------------------
 LeagueServiceProvider.php 2020-04-03
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

namespace Gambio\Core\Application\ServiceProviders\Abstraction;

use League\Container\ServiceProvider\AbstractServiceProvider as AbstractLeagueServiceProvider;

/**
 * Class LeagueServiceProvider
 * @package Gambio\Core\Application\ServiceProviders\Abstraction
 */
class LeagueServiceProvider extends AbstractLeagueServiceProvider
{
    /**
     * @var AbstractServiceProvider
     */
    private $adapter;
    
    
    /**
     * LeagueServiceProvider constructor.
     *
     * @param AbstractServiceProvider $serviceProvider
     */
    public function __construct(AbstractServiceProvider $serviceProvider)
    {
        $this->adapter  = $serviceProvider;
        $this->provides = $serviceProvider->provides();
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->adapter->register();
    }
    
    
    /**
     * Overrides the identifier accessor.
     * Instead of using the class name as fallback identifier, we will use the name of the adapters class.
     *
     * @return string
     */
    public function getIdentifier(): string
    {
        return $this->identifier ?? get_class($this->adapter);
    }
}